* Title: 	table8.do
* Version: 	23 May 2018
* Purpose: 	Produce summary statistics for 2016 Consumer Expenditure Survey


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table8, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/cex_clean, clear

* Keep only prime-age men
keep if (sex == 1 & age>=25 & age<=54)


*******************************************************************************
* (2) Create table of income sources
*******************************************************************************

* Group 1: employed, all
gen group1 = (earner == 1)

* Group 2: employed, living alone
gen group2 =  (earner == 1 & H_Size_Adults == 1)

* Group 3: employed, living alone, low-income
gen group3 =  (earner == 1 & H_Size_Adults == 1 & income_pretax < 40000)

* Group 4: long-term jobless, living alone
gen group4 =  (earner == 2 & incomey != 6 & H_Size_Adults == 1)


forval i = 1/4 {
	foreach var of varlist *weight {
		assert !mi(`var')
		gen `var'`i' = `var' if (group`i' == 1)
	}
}

collapse 	(sum)	*weight1 *weight2 *weight3 *weight4

* Compute means:
forval i = 1/4 {
	foreach var in income_pretax	///
				total_tax			///
				income_posttax		///
				totexp				///
				food				///
				housing				///
				apparel				///
				transport			///
				personalcare		///
				health				///
				entertainment		///
				alcohol				///
				tobacco {
		gen `var'`i' = `var'_weight`i'/cal_popweight`i'
	}
	
	gen otherexp`i' = totexp`i' - (food`i' + housing`i' + apparel`i' + ///
								   transport`i' + personalcare`i' + health`i' + ///
								   entertainment`i' + alcohol`i' + tobacco`i')
	
	ren income_pretax`i' 	Group`i'a_income_pretax
	ren total_tax`i' 		Group`i'b_total_tax
	ren income_posttax`i'	Group`i'c_income_posttax
	ren totexp`i'			Group`i'd_totexp
	ren food`i'				Group`i'e_food
	ren housing`i'			Group`i'f_housing
	ren apparel`i'			Group`i'g_apparel
	ren transport`i'		Group`i'h_transport
	ren personalcare`i'		Group`i'i_personalcare
	ren health`i'			Group`i'j_health
	ren entertainment`i'	Group`i'k_entertainment
	ren alcohol`i'			Group`i'l_alcohol
	ren tobacco`i'			Group`i'm_tobacco
	ren otherexp`i'			Group`i'n_otherexp
	
}
keep Group*
gen Total = 1
reshape long Group1 Group2 Group3 Group4, i(Total) j(category) str
drop Total

replace category = "Pre-tax household income"	if category == "a_income_pretax"
replace category = "Tax" 						if category == "b_total_tax"
replace category = "Post-tax household income"	if category == "c_income_posttax"
replace category = "Total expenditure" 			if category == "d_totexp"
replace category = "Food" 						if category == "e_food"
replace category = "Housing" 					if category == "f_housing"
replace category = "Apparel and services" 		if category == "g_apparel"
replace category = "Transportation" 			if category == "h_transport"
replace category = "Personal care" 				if category == "i_personalcare"
replace category = "Healthcare" 				if category == "j_health"
replace category = "Entertainment" 				if category == "k_entertainment"
replace category = "Alcohol"					if category == "l_alcohol"
replace category = "Tobacco products" 			if category == "m_tobacco"
replace category = "Other expenditure" 			if category == "n_otherexp"

ren Group1 Employed_All
ren Group2 Employed_LiveAlone
ren Group3 Employed_LiveAlone_LowIncome
ren Group4 LTJobless_LiveAlone

* Save dataset
save output/tables/dta/table8.dta, replace


*******************************************************************************
* (3) End of file
*******************************************************************************

log close
exit, clear
